#!/usr/bin/env python3
"""
# Zipping output of bruteforce
import gzip
import base64

with open("ans.out", "rb") as f:
    raw = f.read()

compressed = gzip.compress(raw)
encoded = base64.b64encode(compressed).decode("ascii")

with open("ansb64.out", "w") as f:
    f.write(encoded)



"""
import gzip
import base64

encoded = "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"
compressed = base64.b64decode(encoded)

s = gzip.decompress(compressed).decode('ascii')
num = [500,200,100,50,20,10,5,2,1]

n = int(input())
s = s.splitlines()
if s[n*2-2][0]!='u':
    print(s[n*2-2])
print(s[n*2-1])