import java.util.*;
import java.io.*;

public class jeroen_n2 {
	public static void main(String[] args) throws IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		int n = Integer.valueOf(in.readLine());
		ArrayList<Integer>[] deps = new ArrayList[n];
		for(int i = 0; i < n; i++)
			deps[i] = new ArrayList<Integer>();
		int[] indeg = new int[n];
		for(int i = 0; i < n; i++) {
			String[] ps = in.readLine().split(" ");
			String t = ps[0].substring(0, ps[0].length() - 1);
			int idx = getNum(t);
			for(int j = 1; j < ps.length; j++) {
				deps[getNum(ps[j])].add(idx);
				indeg[idx]++;
			}
		}
		int changed = getNum(in.readLine());
		
		// Handle the part of the graph not dependent on changed
		boolean[] done = new boolean[n];
		boolean goOn;
		do {
			goOn = false;
			for(int i = 0; i < n; i++) {
				if(!done[i] && indeg[i] == 0 && i != changed) {
					goOn = done[i] = true;
					for(Integer next : deps[i])
						indeg[next]--;
				}
			}
		} while(goOn);
		
		// And now the rest
		do {
			goOn = false;
			for(int i = 0; i < n; i++) {
				if(!done[i] && indeg[i] == 0) {
					System.out.println(names.get(i));
					goOn = done[i] = true;
					for(Integer next : deps[i])
						indeg[next]--;
				}
			}
		} while(goOn);
	}
	
	private static Map<String, Integer> nums = new HashMap<String, Integer>();
	private static ArrayList<String> names = new ArrayList<String>();
	
	public static int getNum(String s) {
		if(!nums.containsKey(s)) {
			nums.put(s, nums.size());
			names.add(s);
		}
		return nums.get(s);
	}
}