import java.util.*;
import java.io.*;

public class jeroen_stack {
	public static void main(String[] args) throws IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		int n = Integer.valueOf(in.readLine());
		ArrayList<Integer>[] deps = new ArrayList[n];
		for(int i = 0; i < n; i++)
			deps[i] = new ArrayList<Integer>();
		int[] indeg = new int[n];
		Stack<Integer> todo = new Stack<Integer>();
		for(int i = 0; i < n; i++) {
			String[] ps = in.readLine().split(" ");
			String t = ps[0].substring(0, ps[0].length() - 1);
			int idx = getNum(t);
			for(int j = 1; j < ps.length; j++) {
				deps[getNum(ps[j])].add(idx);
				indeg[idx]++;
			}
			if(indeg[idx] == 0) todo.push(idx);
		}
		int changed = getNum(in.readLine());
		
		// Handle the part of the graph not dependent on changed
		while(!todo.isEmpty()) {
			int top = todo.pop();
			if(top == changed) continue;
			for(Integer next : deps[top]) {
				if(--indeg[next] == 0) {
					todo.push(next);
				}
			}
		}
		
		// And now the rest
		todo.push(changed);
		while(!todo.isEmpty()) {
			int top = todo.pop();
			System.out.println(names.get(top));
			for(Integer next : deps[top]) {
				if(--indeg[next] == 0) {
					todo.push(next);
				}
			}
		}
	}
	
	private static Map<String, Integer> nums = new HashMap<String, Integer>();
	private static ArrayList<String> names = new ArrayList<String>();
	
	public static int getNum(String s) {
		if(!nums.containsKey(s)) {
			nums.put(s, nums.size());
			names.add(s);
		}
		return nums.get(s);
	}
}