#include <iostream>
#include <map>
#include <set>
#include <string>
#include <vector>

std::map<std::string, std::vector<std::string>> deps;
std::set<std::string> visited;
std::vector<std::string> order;

void toposort(const std::string& s) {
  if (!visited.insert(s).second) return;
  for (const auto& t : deps[s]) toposort(t);
  order.push_back(s);
}

int main() {
  int n;
  std::cin >> n;

  std::vector<std::string> strs;
  for (std::string s; std::cin >> s; strs.push_back(s)) {}

  std::string query = strs.back();
  strs.resize(strs.size() - 1);

  for (int i = 0, j; i < strs.size(); i = j) {
    for (j = i + 1; j < strs.size() && strs[j].back() != ':'; ++j) {}
    strs[i].resize(strs[i].size() - 1);
    for (int k = i + 1; k < j; ++k) deps[strs[k]].push_back(strs[i]);
  }

  visited.clear();
  toposort(query);
  for (auto s = order.rbegin(); s != order.rend(); ++s) {
    std::cout << *s << std::endl;
  }

  return 0;
}
