import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;

/**
 * This is a solution of the builddeps problem. We execute a BFS in the
 * dependencies to find all files that need to be recompiled and count the
 * number of their dependencies that need to be recompiled. Then we find all
 * files that can be recompiled one after another.
 * 
 * @author Stefan Toman (toman@tum.de)
 *
 */
public class Stefan {
	public static void main(String[] args) throws NumberFormatException, IOException {
		// read input
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		int n = Integer.parseInt(in.readLine());
		HashMap<String, List<String>> dependents = new HashMap<String, List<String>>();
		for (int i = 0; i < n; i++) {
			String[] line = in.readLine().split(":");
			if (!dependents.containsKey(line[0])) {
				dependents.put(line[0], new LinkedList<String>());
			}
			if (line.length < 2)
				continue;
			String[] deps = line[1].trim().split(" ");
			for (int j = 0; j < deps.length; j++) {
				if (!dependents.containsKey(deps[j])) {
					dependents.put(deps[j], new LinkedList<String>());
				}
				dependents.get(deps[j]).add(line[0]);
			}
		}
		String start = in.readLine();

		// get all dependent files
		Queue<String> q = new LinkedList<String>();
		Set<String> dependent = new HashSet<String>();
		HashMap<String, Integer> num = new HashMap<String, Integer>();
		q.add(start);
		dependent.add(start);
		while (!q.isEmpty()) {
			String file = q.poll();
			for (String dep : dependents.get(file)) {
				if (!num.containsKey(dep)) {
					num.put(dep, 1);
				} else {
					num.put(dep, num.get(dep) + 1);
				}
				if (!dependent.contains(dep)) {
					q.add(dep);
					dependent.add(dep);
				}
			}
		}

		// print results in order
		StringBuilder sb = new StringBuilder();
		q.add(start);
		while (!q.isEmpty()) {
			String file = q.poll();
			sb.append(file).append("\n");
			for (String dep : dependents.get(file)) {
				num.put(dep, num.get(dep) - 1);
				if (num.get(dep) == 0) {
					q.add(dep);
				}
			}
		}
		System.out.print(sb);
	}
}
