import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;

// sorts DAG and remembers needed targets
public class Egor {

	static Map<String, Integer> name2id=new HashMap<String, Integer>();
	static String[] id2name;
	
	static int getId(String name){
		Integer result=name2id.get(name);
		if(result==null){
			int id=name2id.size();
			name2id.put(name, id);
			id2name[id]= name;
			result=id;
		}
		return result;
	}
	
	
	public static void main(String[] args) throws Exception {
		BufferedReader reader=new BufferedReader(new InputStreamReader(System.in));
		int N=Integer.parseInt(reader.readLine());
		id2name=new String[N];
		
		int[] incomming=new int[N];
		
		List<Integer>[] graph=new List[N];
		for(int i=0;i<N;i++)
			graph[i]=new LinkedList<Integer>();
		
		for(int i=0;i<N;i++){
			String[] ss=reader.readLine().split(" ");
			int to=getId(ss[0].substring(0,ss[0].length()-1));
			for(int j=1;j<ss.length;j++){
				graph[getId(ss[j])].add(to);
				incomming[to]++;
			}
		}
		
		int start=getId(reader.readLine());
		
		boolean[] needed=new boolean[N];
		needed[start]=true;
		

		//sort dag:
		Queue<Integer> q=new LinkedList<Integer>();
		
		for(int i=0;i<N;i++)
			if(incomming[i]==0)
				q.offer(i);
		
		StringBuilder result=new StringBuilder();
		while(!q.isEmpty()){
			int current=q.poll();
			if(needed[current])
					result.append(id2name[current]+"\n");
			
			for(int next:graph[current]){
				needed[next]|=needed[current];
				incomming[next]--;
				if(incomming[next]==0)
					q.offer(next);
			}
		}
		
		System.out.print(result.toString());
	}

}
