#include <vector>
#include <map>
#include <set>
#include <iostream>
#include <string>
#include <algorithm>
#include <cstring>
#include "streamcorr.h"

using namespace std;

int n;
map<string, set<string> > deps;
string changed;

typedef	vector<string> solution;

solution read_sol(istream& in, void (*error)(const char *err, ...)) {
	solution ret;

	string target;
	while(in >> target) {
		// transform tolower, to make sure case differences don't matter
		// http://stackoverflow.com/questions/313970/how-to-convert-stdstring-to-lower-case
		transform(target.begin(), target.end(), target.begin(), ::tolower);
		ret.push_back(target);
	}

	return ret;
}

// Check if a solution is valid; does not check if this is minimal solution
void check_valid(solution sol, void (*error)(const char *err, ...)) {
	// Check if targets exist and number them
	map<string,int> num;
	for(vector<string>::iterator it = sol.begin(); it != sol.end(); it++) {
		if(deps.find(*it) == deps.end())
			error("Invalid target %s", it->c_str());
		if(num.find(*it) != num.end())
			error("Duplicate target %s", it->c_str());
		num[*it] = num.size();
	}
	
	// Basic checks
	if(sol.size() == 0) error("Empty list of targets");
	if(sol[0] != changed) error("First target is not the changed file");

	// Check if all direct dependencies are satisfied
	for(map<string, set<string> >::iterator it = deps.begin(); it != deps.end(); it++) {
		for(set<string>::iterator it2 = it->second.begin(); it2 != it->second.end(); it2++) {
			if(num.find(*it2) != num.end()) {
				// *it2 must come before num[it->first]
				int n2 = num[*it2];
				if(num.find(it->first) == num.end() || n2 >= num[it->first])
					error("Dependency %s: %s not satisfied", it->first.c_str(), it2->c_str());
			}
		}
	}
}

int main(int argc, char **argv) {
	init_io(argc, argv);

	// read input
	judge_in >> n;
	for(int i = 0; i < n; i++) {
		string t;
		judge_in >> t;
		t = t.substr(0, t.size()-1);
		set<string> dps;
		while(judge_in.peek() != '\n') {
			string d;
			judge_in >> d;
			dps.insert(d);
		}
		deps[t] = dps;
	}
	judge_in >> changed;

	// Read judge and contestant output
	solution judge = read_sol(judge_ans, judge_error);
	solution team = read_sol(author_out, report_error);

	// check if answers are valid
	check_valid(judge, judge_error);
	check_valid(team, report_error);

	// Must contain the same set of dependencies
	if(judge.size() != team.size())
		report_error("Jury and team solution have a different number of targets");
	set<string> judgeset (judge.begin(), judge.end());
	set<string> teamset (team.begin(), team.end());
	if(judgeset != teamset)
		report_error("Jury and team solution have a different set of targets");

	/* Check for trailing output in author file. */
	string trash;
	if (judge_in   >> trash) judge_error("Trailing output in input data");
	if (judge_ans  >> trash) judge_error("Trailing output in judge data");
	if (author_out >> trash) report_error("Trailing output in team output");

	/* Yay! */
	accept();
	return 0;
}
