#include <bits/stdc++.h>

using namespace std;
#define FOR(i,a,b) for (int i=(a); i<(b); i++)
#define ACTIVE 1
#define DONE 2
int N, numNames;
unordered_map<string,int> nameToInt;
string names[100005], tmp;
vector<int> adj[100005], rebuild;
bool isRule[100005];
int state[100005];

int getID(string s) {
	if (nameToInt.count(s) == 0) {
		nameToInt[s] = numNames;
		names[numNames++] = s;
	}
	return nameToInt[s];
}

void checkDAG(int node) {
	if (state[node] == DONE) return;
	assert(state[node] != ACTIVE && "Input is not a DAG");
	state[node] = ACTIVE;
	for (int next : adj[node]) checkDAG(next);
	state[node] = DONE;
}

int main() {
	cin >> N;
	FOR(i, 0, N) {
		cin >> tmp;
		int target = getID(tmp.substr(0, tmp.size() - 1));
		assert(!isRule[target] && "File is listed twice on left side.");	
		isRule[target] = true;
		getline(cin, tmp);
		stringstream ss(tmp);
		while (ss >> tmp) adj[getID(tmp)].push_back(target);
	}
	cin >> tmp;
	assert(nameToInt.count(tmp) == 1 && "Changed file is unknown");

	assert(numNames == N && "Incorrect total number of file names.");
	FOR(i, 0, N) assert(isRule[i] && "File is not listed as rule (left side).");
	FOR(i, 0, N) state[i] = 0;
	FOR(i, 0, N) checkDAG(i);

	return 42;
}
