import java.util.*;
import java.io.*;

public class gendata {
	private static Random rand;
	private static final int MAXN = 100000;
	
	public static void main(String[] args) {
		rand = new Random(Long.valueOf(args[0]));
		
		// Some worst cases
		genData(args, 1, MAXN, false, true, false, false, false, false);
		genData(args, 2, MAXN, true, true, false, false, false, false);
		genData(args, 3, MAXN, true, true, true, false, false, false);
		
		// random cases
		for(int i = 4; i <= 15; i++)
			genData(args, i, rand.nextInt(MAXN)+1, true, false, true, true, true, false);
		
		// Bad case for jeroen_n2
		genData(args, 16, MAXN, false, true, false, false, false, true);
	}
	
	public static void genData(String[] args, int cnt, int n, boolean doShuffle, boolean maxName, boolean randDeps,
			boolean randNDeps, boolean randChanged, boolean doReverse) {
		if (Integer.valueOf(args[1]) != cnt)
			return;
		
		allNames.clear();
		List<String> names = new ArrayList<String>();
		
		for(int i = 0; i < n; i++)
			names.add(randName(maxName));
		
		List<String> lines = new ArrayList<String>();
		for(int i = 0; i < n; i++) {
			StringBuilder sb = new StringBuilder();
			sb.append(names.get(i));
			sb.append(':');
			int ndeps = i == 0 ? 0 : randNDeps ? rand.nextInt(Math.min(i,5)) : Math.min(i,5);
			HashSet<String> deps = new HashSet<String>();
			for(int j = 0; j < ndeps; j++)
				deps.add(names.get(randDeps ? rand.nextInt(i) : i - j - 1));
			List<String> ldeps = new ArrayList<String>(deps);
			if(doShuffle)
				Collections.shuffle(ldeps, rand);
			for(String d : ldeps) {
				sb.append(' ');
				sb.append(d);
			}
			lines.add(sb.toString());
		}
		if(doShuffle)
			Collections.shuffle(lines, rand);
		else if(doReverse)
			Collections.reverse(lines);
		
		try {
			PrintStream out = new PrintStream("testcase.in");
			out.println(n);
			for(String line : lines)
				out.println(line);
			out.println(names.get(randChanged ? rand.nextInt(n) : 0));
			out.close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	private static HashSet<String> allNames = new HashSet<String>();
	
	private static String randName(boolean maxName) {
		String ret;
		do {
			int len = maxName ? 10 : rand.nextInt(10)+1;
			StringBuilder sb = new StringBuilder();
			for(int i = 0; i < len; i++)
				sb.append((char)('a' + rand.nextInt(26)));
			ret = sb.toString();
		} while(allNames.contains(ret));
		allNames.add(ret);
		return ret;
	}
}
